package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeTypeCost;
import com.xforceplus.financialsettlement.service.IChargeCodeTypeCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class ChargeCodeTypeCostController {

  @Autowired
  private IChargeCodeTypeCostService chargeCodeTypeCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeTypeCost ${table.comment}
   * @return
   */
  @GetMapping("/chargecodetypecosts" )
  public XfR getChargeCodeTypeCosts(XfPage page, ChargeCodeTypeCost chargeCodeTypeCost) {
    return XfR.ok(chargeCodeTypeCostServiceImpl.page(page, Wrappers.query(chargeCodeTypeCost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodetypecosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeTypeCostServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeTypeCost ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodetypecosts")
  public XfR save(@RequestBody ChargeCodeTypeCost chargeCodeTypeCost) {
     return XfR.ok(chargeCodeTypeCostServiceImpl.save(chargeCodeTypeCost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeTypeCost ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodetypecosts/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeTypeCost chargeCodeTypeCost,@PathVariable Long id) {
      chargeCodeTypeCost.setId(id);
      return XfR.ok(chargeCodeTypeCostServiceImpl.updateById(chargeCodeTypeCost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeTypeCost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodetypecosts/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeTypeCost chargeCodeTypeCost,@PathVariable Long id) {
      ChargeCodeTypeCost upchargeCodeTypeCost = chargeCodeTypeCostServiceImpl.getById(id);
      if(upchargeCodeTypeCost != null){
        upchargeCodeTypeCost = ObjectCopyUtils.copyProperties(chargeCodeTypeCost,upchargeCodeTypeCost,true);
      }
      return XfR.ok(chargeCodeTypeCostServiceImpl.updateById(upchargeCodeTypeCost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodetypecosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeTypeCostServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodetypecosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_type_cost");
     params.put("request", condition);

     return XfR.ok(chargeCodeTypeCostServiceImpl.querys(params));
  }

}
