package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialProjectShareAdjustBill;
import com.xforceplus.financialsettlement.service.IFinancialProjectShareAdjustBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class FinancialProjectShareAdjustBillController {

  @Autowired
  private IFinancialProjectShareAdjustBillService financialProjectShareAdjustBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialProjectShareAdjustBill ${table.comment}
   * @return
   */
  @GetMapping("/financialprojectshareadjustbills" )
  public XfR getFinancialProjectShareAdjustBills(XfPage page, FinancialProjectShareAdjustBill financialProjectShareAdjustBill) {
    return XfR.ok(financialProjectShareAdjustBillServiceImpl.page(page, Wrappers.query(financialProjectShareAdjustBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialprojectshareadjustbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialProjectShareAdjustBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialProjectShareAdjustBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialprojectshareadjustbills")
  public XfR save(@RequestBody FinancialProjectShareAdjustBill financialProjectShareAdjustBill) {
     return XfR.ok(financialProjectShareAdjustBillServiceImpl.save(financialProjectShareAdjustBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialProjectShareAdjustBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialprojectshareadjustbills/{id}")
  public XfR putUpdate(@RequestBody FinancialProjectShareAdjustBill financialProjectShareAdjustBill,@PathVariable Long id) {
      financialProjectShareAdjustBill.setId(id);
      return XfR.ok(financialProjectShareAdjustBillServiceImpl.updateById(financialProjectShareAdjustBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialProjectShareAdjustBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialprojectshareadjustbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialProjectShareAdjustBill financialProjectShareAdjustBill,@PathVariable Long id) {
      FinancialProjectShareAdjustBill upfinancialProjectShareAdjustBill = financialProjectShareAdjustBillServiceImpl.getById(id);
      if(upfinancialProjectShareAdjustBill != null){
        upfinancialProjectShareAdjustBill = ObjectCopyUtils.copyProperties(financialProjectShareAdjustBill,upfinancialProjectShareAdjustBill,true);
      }
      return XfR.ok(financialProjectShareAdjustBillServiceImpl.updateById(upfinancialProjectShareAdjustBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialprojectshareadjustbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialProjectShareAdjustBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialprojectshareadjustbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_project_share_adjust_bill");
     params.put("request", condition);

     return XfR.ok(financialProjectShareAdjustBillServiceImpl.querys(params));
  }

}
