package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ContractDetail;
import com.xforceplus.financialsettlement.service.IContractDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 合同明细前端控制器
 *
 * @author ultraman
 * @date 2024-03-14
 */
@RestController
public class ContractDetailController {

  @Autowired
  private IContractDetailService contractDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param contractDetail 合同明细
   * @return
   */
  @GetMapping("/contractdetails" )
  public XfR getContractDetails(XfPage page, ContractDetail contractDetail) {
    return XfR.ok(contractDetailServiceImpl.page(page, Wrappers.query(contractDetail)));
  }

  /**
   * 通过id查询合同明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/contractdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(contractDetailServiceImpl.getById(id));
  }

  /**
   * 新增合同明细
   * @param contractDetail 合同明细
   * @return XfR
   */
  @PostMapping("/contractdetails")
  public XfR save(@RequestBody ContractDetail contractDetail) {
     return XfR.ok(contractDetailServiceImpl.save(contractDetail));
  }

  /**
   * 修改-传入修改后的全部数据合同明细
   * @param contractDetail 合同明细
   * @return XfR
   */
  @PutMapping("/contractdetails/{id}")
  public XfR putUpdate(@RequestBody ContractDetail contractDetail,@PathVariable Long id) {
      contractDetail.setId(id);
      return XfR.ok(contractDetailServiceImpl.updateById(contractDetail));
  }

  /**
   * 修改-传入修改的数据合同明细
   * @param contractDetail 合同明细
   * @return XfR
   */
  @PatchMapping("/contractdetails/{id}")
  public XfR patchUpdate(@RequestBody ContractDetail contractDetail,@PathVariable Long id) {
      ContractDetail upcontractDetail = contractDetailServiceImpl.getById(id);
      if(upcontractDetail != null){
        upcontractDetail = ObjectCopyUtils.copyProperties(contractDetail,upcontractDetail,true);
      }
      return XfR.ok(contractDetailServiceImpl.updateById(upcontractDetail));
  }

  /**
   * 通过id删除合同明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/contractdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(contractDetailServiceImpl.removeById(id));
  }

  @PostMapping("/contractdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "contract_detail");
     params.put("request", condition);

     return XfR.ok(contractDetailServiceImpl.querys(params));
  }

}
