package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.DdRiverOrder;
import com.xforceplus.financialsettlement.service.IDdRiverOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-14
 */
@RestController
public class DdRiverOrderController {

  @Autowired
  private IDdRiverOrderService ddRiverOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ddRiverOrder ${table.comment}
   * @return
   */
  @GetMapping("/ddriverorders" )
  public XfR getDdRiverOrders(XfPage page, DdRiverOrder ddRiverOrder) {
    return XfR.ok(ddRiverOrderServiceImpl.page(page, Wrappers.query(ddRiverOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ddriverorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ddRiverOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ddRiverOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/ddriverorders")
  public XfR save(@RequestBody DdRiverOrder ddRiverOrder) {
     return XfR.ok(ddRiverOrderServiceImpl.save(ddRiverOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ddRiverOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/ddriverorders/{id}")
  public XfR putUpdate(@RequestBody DdRiverOrder ddRiverOrder,@PathVariable Long id) {
      ddRiverOrder.setId(id);
      return XfR.ok(ddRiverOrderServiceImpl.updateById(ddRiverOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ddRiverOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ddriverorders/{id}")
  public XfR patchUpdate(@RequestBody DdRiverOrder ddRiverOrder,@PathVariable Long id) {
      DdRiverOrder upddRiverOrder = ddRiverOrderServiceImpl.getById(id);
      if(upddRiverOrder != null){
        upddRiverOrder = ObjectCopyUtils.copyProperties(ddRiverOrder,upddRiverOrder,true);
      }
      return XfR.ok(ddRiverOrderServiceImpl.updateById(upddRiverOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ddriverorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ddRiverOrderServiceImpl.removeById(id));
  }

  @PostMapping("/ddriverorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dd_river_order");
     params.put("request", condition);

     return XfR.ok(ddRiverOrderServiceImpl.querys(params));
  }

}
