package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialProjectShareAdjustBillDetail;
import com.xforceplus.financialsettlement.service.IFinancialProjectShareAdjustBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-14
 */
@RestController
public class FinancialProjectShareAdjustBillDetailController {

  @Autowired
  private IFinancialProjectShareAdjustBillDetailService financialProjectShareAdjustBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialProjectShareAdjustBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialprojectshareadjustbilldetails" )
  public XfR getFinancialProjectShareAdjustBillDetails(XfPage page, FinancialProjectShareAdjustBillDetail financialProjectShareAdjustBillDetail) {
    return XfR.ok(financialProjectShareAdjustBillDetailServiceImpl.page(page, Wrappers.query(financialProjectShareAdjustBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialprojectshareadjustbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialProjectShareAdjustBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialProjectShareAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialprojectshareadjustbilldetails")
  public XfR save(@RequestBody FinancialProjectShareAdjustBillDetail financialProjectShareAdjustBillDetail) {
     return XfR.ok(financialProjectShareAdjustBillDetailServiceImpl.save(financialProjectShareAdjustBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialProjectShareAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialprojectshareadjustbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialProjectShareAdjustBillDetail financialProjectShareAdjustBillDetail,@PathVariable Long id) {
      financialProjectShareAdjustBillDetail.setId(id);
      return XfR.ok(financialProjectShareAdjustBillDetailServiceImpl.updateById(financialProjectShareAdjustBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialProjectShareAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialprojectshareadjustbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialProjectShareAdjustBillDetail financialProjectShareAdjustBillDetail,@PathVariable Long id) {
      FinancialProjectShareAdjustBillDetail upfinancialProjectShareAdjustBillDetail = financialProjectShareAdjustBillDetailServiceImpl.getById(id);
      if(upfinancialProjectShareAdjustBillDetail != null){
        upfinancialProjectShareAdjustBillDetail = ObjectCopyUtils.copyProperties(financialProjectShareAdjustBillDetail,upfinancialProjectShareAdjustBillDetail,true);
      }
      return XfR.ok(financialProjectShareAdjustBillDetailServiceImpl.updateById(upfinancialProjectShareAdjustBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialprojectshareadjustbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialProjectShareAdjustBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialprojectshareadjustbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_project_share_adjust_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialProjectShareAdjustBillDetailServiceImpl.querys(params));
  }

}
