package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.MemberInfo;
import com.xforceplus.financialsettlement.service.IMemberInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-14
 */
@RestController
public class MemberInfoController {

  @Autowired
  private IMemberInfoService memberInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param memberInfo ${table.comment}
   * @return
   */
  @GetMapping("/memberinfos" )
  public XfR getMemberInfos(XfPage page, MemberInfo memberInfo) {
    return XfR.ok(memberInfoServiceImpl.page(page, Wrappers.query(memberInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/memberinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(memberInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param memberInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/memberinfos")
  public XfR save(@RequestBody MemberInfo memberInfo) {
     return XfR.ok(memberInfoServiceImpl.save(memberInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param memberInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/memberinfos/{id}")
  public XfR putUpdate(@RequestBody MemberInfo memberInfo,@PathVariable Long id) {
      memberInfo.setId(id);
      return XfR.ok(memberInfoServiceImpl.updateById(memberInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param memberInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/memberinfos/{id}")
  public XfR patchUpdate(@RequestBody MemberInfo memberInfo,@PathVariable Long id) {
      MemberInfo upmemberInfo = memberInfoServiceImpl.getById(id);
      if(upmemberInfo != null){
        upmemberInfo = ObjectCopyUtils.copyProperties(memberInfo,upmemberInfo,true);
      }
      return XfR.ok(memberInfoServiceImpl.updateById(upmemberInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/memberinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(memberInfoServiceImpl.removeById(id));
  }

  @PostMapping("/memberinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "member_info");
     params.put("request", condition);

     return XfR.ok(memberInfoServiceImpl.querys(params));
  }

}
