package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.MemberShareCostSnapshot;
import com.xforceplus.financialsettlement.service.IMemberShareCostSnapshotService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-14
 */
@RestController
public class MemberShareCostSnapshotController {

  @Autowired
  private IMemberShareCostSnapshotService memberShareCostSnapshotServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param memberShareCostSnapshot ${table.comment}
   * @return
   */
  @GetMapping("/membersharecostsnapshots" )
  public XfR getMemberShareCostSnapshots(XfPage page, MemberShareCostSnapshot memberShareCostSnapshot) {
    return XfR.ok(memberShareCostSnapshotServiceImpl.page(page, Wrappers.query(memberShareCostSnapshot)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/membersharecostsnapshots/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(memberShareCostSnapshotServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param memberShareCostSnapshot ${table.comment}
   * @return XfR
   */
  @PostMapping("/membersharecostsnapshots")
  public XfR save(@RequestBody MemberShareCostSnapshot memberShareCostSnapshot) {
     return XfR.ok(memberShareCostSnapshotServiceImpl.save(memberShareCostSnapshot));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param memberShareCostSnapshot ${table.comment}
   * @return XfR
   */
  @PutMapping("/membersharecostsnapshots/{id}")
  public XfR putUpdate(@RequestBody MemberShareCostSnapshot memberShareCostSnapshot,@PathVariable Long id) {
      memberShareCostSnapshot.setId(id);
      return XfR.ok(memberShareCostSnapshotServiceImpl.updateById(memberShareCostSnapshot));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param memberShareCostSnapshot ${table.comment}
   * @return XfR
   */
  @PatchMapping("/membersharecostsnapshots/{id}")
  public XfR patchUpdate(@RequestBody MemberShareCostSnapshot memberShareCostSnapshot,@PathVariable Long id) {
      MemberShareCostSnapshot upmemberShareCostSnapshot = memberShareCostSnapshotServiceImpl.getById(id);
      if(upmemberShareCostSnapshot != null){
        upmemberShareCostSnapshot = ObjectCopyUtils.copyProperties(memberShareCostSnapshot,upmemberShareCostSnapshot,true);
      }
      return XfR.ok(memberShareCostSnapshotServiceImpl.updateById(upmemberShareCostSnapshot));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/membersharecostsnapshots/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(memberShareCostSnapshotServiceImpl.removeById(id));
  }

  @PostMapping("/membersharecostsnapshots/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "member_share_cost_snapshot");
     params.put("request", condition);

     return XfR.ok(memberShareCostSnapshotServiceImpl.querys(params));
  }

}
