package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.BillAttachmentSyn;
import com.xforceplus.financialsettlement.service.IBillAttachmentSynService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 单据附件同步信息-易快报前端控制器
 *
 * @author ultraman
 * @date 2024-03-20
 */
@RestController
public class BillAttachmentSynController {

  @Autowired
  private IBillAttachmentSynService billAttachmentSynServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billAttachmentSyn 单据附件同步信息-易快报
   * @return
   */
  @GetMapping("/billattachmentsyns" )
  public XfR getBillAttachmentSyns(XfPage page, BillAttachmentSyn billAttachmentSyn) {
    return XfR.ok(billAttachmentSynServiceImpl.page(page, Wrappers.query(billAttachmentSyn)));
  }

  /**
   * 通过id查询单据附件同步信息-易快报
   * @param  id
   * @return XfR
   */
  @GetMapping("/billattachmentsyns/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billAttachmentSynServiceImpl.getById(id));
  }

  /**
   * 新增单据附件同步信息-易快报
   * @param billAttachmentSyn 单据附件同步信息-易快报
   * @return XfR
   */
  @PostMapping("/billattachmentsyns")
  public XfR save(@RequestBody BillAttachmentSyn billAttachmentSyn) {
     return XfR.ok(billAttachmentSynServiceImpl.save(billAttachmentSyn));
  }

  /**
   * 修改-传入修改后的全部数据单据附件同步信息-易快报
   * @param billAttachmentSyn 单据附件同步信息-易快报
   * @return XfR
   */
  @PutMapping("/billattachmentsyns/{id}")
  public XfR putUpdate(@RequestBody BillAttachmentSyn billAttachmentSyn,@PathVariable Long id) {
      billAttachmentSyn.setId(id);
      return XfR.ok(billAttachmentSynServiceImpl.updateById(billAttachmentSyn));
  }

  /**
   * 修改-传入修改的数据单据附件同步信息-易快报
   * @param billAttachmentSyn 单据附件同步信息-易快报
   * @return XfR
   */
  @PatchMapping("/billattachmentsyns/{id}")
  public XfR patchUpdate(@RequestBody BillAttachmentSyn billAttachmentSyn,@PathVariable Long id) {
      BillAttachmentSyn upbillAttachmentSyn = billAttachmentSynServiceImpl.getById(id);
      if(upbillAttachmentSyn != null){
        upbillAttachmentSyn = ObjectCopyUtils.copyProperties(billAttachmentSyn,upbillAttachmentSyn,true);
      }
      return XfR.ok(billAttachmentSynServiceImpl.updateById(upbillAttachmentSyn));
  }

  /**
   * 通过id删除单据附件同步信息-易快报
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billattachmentsyns/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billAttachmentSynServiceImpl.removeById(id));
  }

  @PostMapping("/billattachmentsyns/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_attachment_syn");
     params.put("request", condition);

     return XfR.ok(billAttachmentSynServiceImpl.querys(params));
  }

}
