package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderRawData;
import com.xforceplus.financialsettlement.service.IOrderRawDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-20
 */
@RestController
public class OrderRawDataController {

  @Autowired
  private IOrderRawDataService orderRawDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderRawData ${table.comment}
   * @return
   */
  @GetMapping("/orderrawdatas" )
  public XfR getOrderRawDatas(XfPage page, OrderRawData orderRawData) {
    return XfR.ok(orderRawDataServiceImpl.page(page, Wrappers.query(orderRawData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderrawdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderRawDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderRawData ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderrawdatas")
  public XfR save(@RequestBody OrderRawData orderRawData) {
     return XfR.ok(orderRawDataServiceImpl.save(orderRawData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderRawData ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderrawdatas/{id}")
  public XfR putUpdate(@RequestBody OrderRawData orderRawData,@PathVariable Long id) {
      orderRawData.setId(id);
      return XfR.ok(orderRawDataServiceImpl.updateById(orderRawData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderRawData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderrawdatas/{id}")
  public XfR patchUpdate(@RequestBody OrderRawData orderRawData,@PathVariable Long id) {
      OrderRawData uporderRawData = orderRawDataServiceImpl.getById(id);
      if(uporderRawData != null){
        uporderRawData = ObjectCopyUtils.copyProperties(orderRawData,uporderRawData,true);
      }
      return XfR.ok(orderRawDataServiceImpl.updateById(uporderRawData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderrawdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderRawDataServiceImpl.removeById(id));
  }

  @PostMapping("/orderrawdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_raw_data");
     params.put("request", condition);

     return XfR.ok(orderRawDataServiceImpl.querys(params));
  }

}
