package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.UntreatedOrderInfo;
import com.xforceplus.financialsettlement.service.IUntreatedOrderInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-20
 */
@RestController
public class UntreatedOrderInfoController {

  @Autowired
  private IUntreatedOrderInfoService untreatedOrderInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param untreatedOrderInfo ${table.comment}
   * @return
   */
  @GetMapping("/untreatedorderinfos" )
  public XfR getUntreatedOrderInfos(XfPage page, UntreatedOrderInfo untreatedOrderInfo) {
    return XfR.ok(untreatedOrderInfoServiceImpl.page(page, Wrappers.query(untreatedOrderInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/untreatedorderinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(untreatedOrderInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param untreatedOrderInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/untreatedorderinfos")
  public XfR save(@RequestBody UntreatedOrderInfo untreatedOrderInfo) {
     return XfR.ok(untreatedOrderInfoServiceImpl.save(untreatedOrderInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param untreatedOrderInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/untreatedorderinfos/{id}")
  public XfR putUpdate(@RequestBody UntreatedOrderInfo untreatedOrderInfo,@PathVariable Long id) {
      untreatedOrderInfo.setId(id);
      return XfR.ok(untreatedOrderInfoServiceImpl.updateById(untreatedOrderInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param untreatedOrderInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/untreatedorderinfos/{id}")
  public XfR patchUpdate(@RequestBody UntreatedOrderInfo untreatedOrderInfo,@PathVariable Long id) {
      UntreatedOrderInfo upuntreatedOrderInfo = untreatedOrderInfoServiceImpl.getById(id);
      if(upuntreatedOrderInfo != null){
        upuntreatedOrderInfo = ObjectCopyUtils.copyProperties(untreatedOrderInfo,upuntreatedOrderInfo,true);
      }
      return XfR.ok(untreatedOrderInfoServiceImpl.updateById(upuntreatedOrderInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/untreatedorderinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(untreatedOrderInfoServiceImpl.removeById(id));
  }

  @PostMapping("/untreatedorderinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "untreated_order_info");
     params.put("request", condition);

     return XfR.ok(untreatedOrderInfoServiceImpl.querys(params));
  }

}
