package com.xforceplus.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.Component;
import com.xforceplus.sdktest.service.IComponentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-05-21
 */
@RestController
public class ComponentController {

  @Autowired
  private IComponentService componentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param component ${table.comment}
   * @return
   */
  @GetMapping("/components" )
  public XfR getComponents(XfPage page, Component component) {
    return XfR.ok(componentServiceImpl.page(page, Wrappers.query(component)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/components/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(componentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param component ${table.comment}
   * @return XfR
   */
  @PostMapping("/components")
  public XfR save(@RequestBody Component component) {
     return XfR.ok(componentServiceImpl.save(component));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param component ${table.comment}
   * @return XfR
   */
  @PutMapping("/components/{id}")
  public XfR putUpdate(@RequestBody Component component,@PathVariable Long id) {
      component.setId(id);
      return XfR.ok(componentServiceImpl.updateById(component));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param component ${table.comment}
   * @return XfR
   */
  @PatchMapping("/components/{id}")
  public XfR patchUpdate(@RequestBody Component component,@PathVariable Long id) {
      Component upcomponent = componentServiceImpl.getById(id);
      if(upcomponent != null){
        upcomponent = ObjectCopyUtils.copyProperties(component,upcomponent,true);
      }
      return XfR.ok(componentServiceImpl.updateById(upcomponent));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/components/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(componentServiceImpl.removeById(id));
  }

  @PostMapping("/components/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "component");
      params.put("request", condition);

     return XfR.ok(componentServiceImpl.querys(params));
  }

}
