package com.xforceplus.gemini.controller;


/**
 * 对账批次feign客户端
 *
 * @author ultraman
 * @date 2025-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.gemini.entity.ReconBatch;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "gemini")
public interface ReconBatchFeignApi {

  /**
   * 通过id查询对账批次
   * @param  id
   * @return R
   */
  @GetMapping("/reconBatch/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增对账批次
   * @param reconBatch 对账批次
   * @return R
   */
  @PostMapping("/reconBatch/add")
  public R save(@RequestBody ReconBatch reconBatch);

  /**
   * 修改对账批次
   * @param reconBatch 对账批次
   * @return R
   */
  @PostMapping("/reconBatch/update")
  public R updateById(@RequestBody ReconBatch reconBatch);

  /**
   * 通过id删除对账批次
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconBatch/del/{id}" )
  public R removeById(@PathVariable Long id);

}