package com.xforceplus.gemini.controller;


/**
 * 对账单明细信息feign客户端
 *
 * @author ultraman
 * @date 2025-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.gemini.entity.ReconBillItemInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "gemini")
public interface ReconBillItemInfoFeignApi {

  /**
   * 通过id查询对账单明细信息
   * @param  id
   * @return R
   */
  @GetMapping("/reconBillItemInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增对账单明细信息
   * @param reconBillItemInfo 对账单明细信息
   * @return R
   */
  @PostMapping("/reconBillItemInfo/add")
  public R save(@RequestBody ReconBillItemInfo reconBillItemInfo);

  /**
   * 修改对账单明细信息
   * @param reconBillItemInfo 对账单明细信息
   * @return R
   */
  @PostMapping("/reconBillItemInfo/update")
  public R updateById(@RequestBody ReconBillItemInfo reconBillItemInfo);

  /**
   * 通过id删除对账单明细信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconBillItemInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}