package com.xforceplus.gemini.controller;


/**
 * 对账结果 - 商品feign客户端
 *
 * @author ultraman
 * @date 2025-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.gemini.entity.ReconGroup;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "gemini")
public interface ReconGroupFeignApi {

  /**
   * 通过id查询对账结果 - 商品
   * @param  id
   * @return R
   */
  @GetMapping("/reconGroup/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增对账结果 - 商品
   * @param reconGroup 对账结果 - 商品
   * @return R
   */
  @PostMapping("/reconGroup/add")
  public R save(@RequestBody ReconGroup reconGroup);

  /**
   * 修改对账结果 - 商品
   * @param reconGroup 对账结果 - 商品
   * @return R
   */
  @PostMapping("/reconGroup/update")
  public R updateById(@RequestBody ReconGroup reconGroup);

  /**
   * 通过id删除对账结果 - 商品
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconGroup/del/{id}" )
  public R removeById(@PathVariable Long id);

}