package com.xforceplus.gemini.controller;


/**
 * 核销结果明细feign客户端
 *
 * @author ultraman
 * @date 2025-03-04
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.gemini.entity.WriteOffResultItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "gemini")
public interface WriteOffResultItemFeignApi {

  /**
   * 通过id查询核销结果明细
   * @param  id
   * @return R
   */
  @GetMapping("/writeOffResultItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增核销结果明细
   * @param writeOffResultItem 核销结果明细
   * @return R
   */
  @PostMapping("/writeOffResultItem/add")
  public R save(@RequestBody WriteOffResultItem writeOffResultItem);

  /**
   * 修改核销结果明细
   * @param writeOffResultItem 核销结果明细
   * @return R
   */
  @PostMapping("/writeOffResultItem/update")
  public R updateById(@RequestBody WriteOffResultItem writeOffResultItem);

  /**
   * 通过id删除核销结果明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/writeOffResultItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}