package com.xforceplus.generalvoucher.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-09-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.TransactionLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "general-voucher")
public interface TransactionLogFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/transactionLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param transactionLog ${table.comment}
   * @return R
   */
  @PostMapping("/transactionLog/add")
  public R save(@RequestBody TransactionLog transactionLog);

  /**
   * 修改${table.comment}
   * @param transactionLog ${table.comment}
   * @return R
   */
  @PostMapping("/transactionLog/update")
  public R updateById(@RequestBody TransactionLog transactionLog);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/transactionLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}