package com.xforceplus.generalvoucher.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-09-26
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.VoucherGenSnapshot;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "general-voucher")
public interface VoucherGenSnapshotFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/voucherGenSnapshot/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param voucherGenSnapshot ${table.comment}
   * @return R
   */
  @PostMapping("/voucherGenSnapshot/add")
  public R save(@RequestBody VoucherGenSnapshot voucherGenSnapshot);

  /**
   * 修改${table.comment}
   * @param voucherGenSnapshot ${table.comment}
   * @return R
   */
  @PostMapping("/voucherGenSnapshot/update")
  public R updateById(@RequestBody VoucherGenSnapshot voucherGenSnapshot);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/voucherGenSnapshot/del/{id}" )
  public R removeById(@PathVariable Long id);

}