package com.xforceplus.generalvoucher.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * voucher_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-19
 */
public enum VoucherStatus {

    _0("0", "待激活"),
    _1("1", "已激活"),
    _2("2", "已冻结"),
    _3("3", "已作废"),
    _6("6", "已核销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VoucherStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
