package com.xforceplus.generalvoucher.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * voucher_gen_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum VoucherGenStatus {

    DRAFT("draft", "草稿"),
    AVAIL("avail", "生效"),
    FROZEN("frozen", "冻结"),
    ABD("abd", "作废"),
    END("end", "结束");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VoucherGenStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherGenStatus fromCode(String code){
        switch(code) {
            case "draft":
                return DRAFT;
            case "avail":
                return AVAIL;
            case "frozen":
                return FROZEN;
            case "abd":
                return ABD;
            case "end":
                return END;
            default:
                return null;
        }
    }
}
