package com.xforceplus.generalvoucher.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * platform_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-24
 */
public enum PlatformType {

    WH("wh", "福利平台"),
    PM("pm", "积分商城"),
    EP("ep", "企业");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PlatformType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PlatformType fromCode(String code){
        switch(code) {
            case "wh":
                return WH;
            case "pm":
                return PM;
            case "ep":
                return EP;
            default:
                return null;
        }
    }
}
