package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.SysFlowActIns;
import com.xforceplus.generalvoucher.service.ISysFlowActInsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统流程节点实例对象前端控制器
 *
 * @author ultraman
 * @date 2025-09-18
 */
@RestController
public class SysFlowActInsController {

  @Autowired
  private ISysFlowActInsService sysFlowActInsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowActIns 系统流程节点实例对象
   * @return
   */
  @GetMapping("/sysflowactinss" )
  public XfR getSysFlowActInss(XfPage page, SysFlowActIns sysFlowActIns) {
    return XfR.ok(sysFlowActInsServiceImpl.page(page, Wrappers.query(sysFlowActIns)));
  }

  /**
   * 通过id查询系统流程节点实例对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowactinss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowActInsServiceImpl.getById(id));
  }

  /**
   * 新增系统流程节点实例对象
   * @param sysFlowActIns 系统流程节点实例对象
   * @return XfR
   */
  @PostMapping("/sysflowactinss")
  public XfR save(@RequestBody SysFlowActIns sysFlowActIns) {
     return XfR.ok(sysFlowActInsServiceImpl.save(sysFlowActIns));
  }

  /**
   * 修改-传入修改后的全部数据系统流程节点实例对象
   * @param sysFlowActIns 系统流程节点实例对象
   * @return XfR
   */
  @PutMapping("/sysflowactinss/{id}")
  public XfR putUpdate(@RequestBody SysFlowActIns sysFlowActIns,@PathVariable Long id) {
      sysFlowActIns.setId(id);
      return XfR.ok(sysFlowActInsServiceImpl.updateById(sysFlowActIns));
  }

  /**
   * 修改-传入修改的数据系统流程节点实例对象
   * @param sysFlowActIns 系统流程节点实例对象
   * @return XfR
   */
  @PatchMapping("/sysflowactinss/{id}")
  public XfR patchUpdate(@RequestBody SysFlowActIns sysFlowActIns,@PathVariable Long id) {
      SysFlowActIns upsysFlowActIns = sysFlowActInsServiceImpl.getById(id);
      if(upsysFlowActIns != null){
        upsysFlowActIns = ObjectCopyUtils.copyProperties(sysFlowActIns,upsysFlowActIns,true);
      }
      return XfR.ok(sysFlowActInsServiceImpl.updateById(upsysFlowActIns));
  }

  /**
   * 通过id删除系统流程节点实例对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowactinss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowActInsServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowactinss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_act_ins");
     params.put("request", condition);

     return XfR.ok(sysFlowActInsServiceImpl.querys(params));
  }

}
