package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.GoodsConfig;
import com.xforceplus.generalvoucher.service.IGoodsConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-19
 */
@RestController
public class GoodsConfigController {

  @Autowired
  private IGoodsConfigService goodsConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsConfig ${table.comment}
   * @return
   */
  @GetMapping("/goodsconfigs" )
  public XfR getGoodsConfigs(XfPage page, GoodsConfig goodsConfig) {
    return XfR.ok(goodsConfigServiceImpl.page(page, Wrappers.query(goodsConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodsconfigs")
  public XfR save(@RequestBody GoodsConfig goodsConfig) {
     return XfR.ok(goodsConfigServiceImpl.save(goodsConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodsconfigs/{id}")
  public XfR putUpdate(@RequestBody GoodsConfig goodsConfig,@PathVariable Long id) {
      goodsConfig.setId(id);
      return XfR.ok(goodsConfigServiceImpl.updateById(goodsConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodsconfigs/{id}")
  public XfR patchUpdate(@RequestBody GoodsConfig goodsConfig,@PathVariable Long id) {
      GoodsConfig upgoodsConfig = goodsConfigServiceImpl.getById(id);
      if(upgoodsConfig != null){
        upgoodsConfig = ObjectCopyUtils.copyProperties(goodsConfig,upgoodsConfig,true);
      }
      return XfR.ok(goodsConfigServiceImpl.updateById(upgoodsConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsConfigServiceImpl.removeById(id));
  }

  @PostMapping("/goodsconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_config");
     params.put("request", condition);

     return XfR.ok(goodsConfigServiceImpl.querys(params));
  }

}
