package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.SystemRelRoleResource;
import com.xforceplus.generalvoucher.service.ISystemRelRoleResourceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 角色资源绑定关系系统对象前端控制器
 *
 * @author ultraman
 * @date 2025-09-19
 */
@RestController
public class SystemRelRoleResourceController {

  @Autowired
  private ISystemRelRoleResourceService systemRelRoleResourceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemRelRoleResource 角色资源绑定关系系统对象
   * @return
   */
  @GetMapping("/systemrelroleresources" )
  public XfR getSystemRelRoleResources(XfPage page, SystemRelRoleResource systemRelRoleResource) {
    return XfR.ok(systemRelRoleResourceServiceImpl.page(page, Wrappers.query(systemRelRoleResource)));
  }

  /**
   * 通过id查询角色资源绑定关系系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemrelroleresources/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemRelRoleResourceServiceImpl.getById(id));
  }

  /**
   * 新增角色资源绑定关系系统对象
   * @param systemRelRoleResource 角色资源绑定关系系统对象
   * @return XfR
   */
  @PostMapping("/systemrelroleresources")
  public XfR save(@RequestBody SystemRelRoleResource systemRelRoleResource) {
     return XfR.ok(systemRelRoleResourceServiceImpl.save(systemRelRoleResource));
  }

  /**
   * 修改-传入修改后的全部数据角色资源绑定关系系统对象
   * @param systemRelRoleResource 角色资源绑定关系系统对象
   * @return XfR
   */
  @PutMapping("/systemrelroleresources/{id}")
  public XfR putUpdate(@RequestBody SystemRelRoleResource systemRelRoleResource,@PathVariable Long id) {
      systemRelRoleResource.setId(id);
      return XfR.ok(systemRelRoleResourceServiceImpl.updateById(systemRelRoleResource));
  }

  /**
   * 修改-传入修改的数据角色资源绑定关系系统对象
   * @param systemRelRoleResource 角色资源绑定关系系统对象
   * @return XfR
   */
  @PatchMapping("/systemrelroleresources/{id}")
  public XfR patchUpdate(@RequestBody SystemRelRoleResource systemRelRoleResource,@PathVariable Long id) {
      SystemRelRoleResource upsystemRelRoleResource = systemRelRoleResourceServiceImpl.getById(id);
      if(upsystemRelRoleResource != null){
        upsystemRelRoleResource = ObjectCopyUtils.copyProperties(systemRelRoleResource,upsystemRelRoleResource,true);
      }
      return XfR.ok(systemRelRoleResourceServiceImpl.updateById(upsystemRelRoleResource));
  }

  /**
   * 通过id删除角色资源绑定关系系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemrelroleresources/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemRelRoleResourceServiceImpl.removeById(id));
  }

  @PostMapping("/systemrelroleresources/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_rel_role_resource");
     params.put("request", condition);

     return XfR.ok(systemRelRoleResourceServiceImpl.querys(params));
  }

}
