package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.StoreConfig;
import com.xforceplus.generalvoucher.service.IStoreConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class StoreConfigController {

  @Autowired
  private IStoreConfigService storeConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param storeConfig ${table.comment}
   * @return
   */
  @GetMapping("/storeconfigs" )
  public XfR getStoreConfigs(XfPage page, StoreConfig storeConfig) {
    return XfR.ok(storeConfigServiceImpl.page(page, Wrappers.query(storeConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/storeconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(storeConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param storeConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/storeconfigs")
  public XfR save(@RequestBody StoreConfig storeConfig) {
     return XfR.ok(storeConfigServiceImpl.save(storeConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param storeConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/storeconfigs/{id}")
  public XfR putUpdate(@RequestBody StoreConfig storeConfig,@PathVariable Long id) {
      storeConfig.setId(id);
      return XfR.ok(storeConfigServiceImpl.updateById(storeConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param storeConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/storeconfigs/{id}")
  public XfR patchUpdate(@RequestBody StoreConfig storeConfig,@PathVariable Long id) {
      StoreConfig upstoreConfig = storeConfigServiceImpl.getById(id);
      if(upstoreConfig != null){
        upstoreConfig = ObjectCopyUtils.copyProperties(storeConfig,upstoreConfig,true);
      }
      return XfR.ok(storeConfigServiceImpl.updateById(upstoreConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/storeconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(storeConfigServiceImpl.removeById(id));
  }

  @PostMapping("/storeconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "store_config");
     params.put("request", condition);

     return XfR.ok(storeConfigServiceImpl.querys(params));
  }

}
