package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.VoucherGenSnapshot;
import com.xforceplus.generalvoucher.service.IVoucherGenSnapshotService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class VoucherGenSnapshotController {

  @Autowired
  private IVoucherGenSnapshotService voucherGenSnapshotServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param voucherGenSnapshot ${table.comment}
   * @return
   */
  @GetMapping("/vouchergensnapshots" )
  public XfR getVoucherGenSnapshots(XfPage page, VoucherGenSnapshot voucherGenSnapshot) {
    return XfR.ok(voucherGenSnapshotServiceImpl.page(page, Wrappers.query(voucherGenSnapshot)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/vouchergensnapshots/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(voucherGenSnapshotServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param voucherGenSnapshot ${table.comment}
   * @return XfR
   */
  @PostMapping("/vouchergensnapshots")
  public XfR save(@RequestBody VoucherGenSnapshot voucherGenSnapshot) {
     return XfR.ok(voucherGenSnapshotServiceImpl.save(voucherGenSnapshot));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param voucherGenSnapshot ${table.comment}
   * @return XfR
   */
  @PutMapping("/vouchergensnapshots/{id}")
  public XfR putUpdate(@RequestBody VoucherGenSnapshot voucherGenSnapshot,@PathVariable Long id) {
      voucherGenSnapshot.setId(id);
      return XfR.ok(voucherGenSnapshotServiceImpl.updateById(voucherGenSnapshot));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param voucherGenSnapshot ${table.comment}
   * @return XfR
   */
  @PatchMapping("/vouchergensnapshots/{id}")
  public XfR patchUpdate(@RequestBody VoucherGenSnapshot voucherGenSnapshot,@PathVariable Long id) {
      VoucherGenSnapshot upvoucherGenSnapshot = voucherGenSnapshotServiceImpl.getById(id);
      if(upvoucherGenSnapshot != null){
        upvoucherGenSnapshot = ObjectCopyUtils.copyProperties(voucherGenSnapshot,upvoucherGenSnapshot,true);
      }
      return XfR.ok(voucherGenSnapshotServiceImpl.updateById(upvoucherGenSnapshot));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/vouchergensnapshots/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(voucherGenSnapshotServiceImpl.removeById(id));
  }

  @PostMapping("/vouchergensnapshots/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "voucher_gen_snapshot");
     params.put("request", condition);

     return XfR.ok(voucherGenSnapshotServiceImpl.querys(params));
  }

}
