package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.Activity;
import com.xforceplus.generalvoucher.service.IActivityService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-25
 */
@RestController
public class ActivityController {

  @Autowired
  private IActivityService activityServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param activity ${table.comment}
   * @return
   */
  @GetMapping("/activitys" )
  public XfR getActivitys(XfPage page, Activity activity) {
    return XfR.ok(activityServiceImpl.page(page, Wrappers.query(activity)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/activitys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(activityServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param activity ${table.comment}
   * @return XfR
   */
  @PostMapping("/activitys")
  public XfR save(@RequestBody Activity activity) {
     return XfR.ok(activityServiceImpl.save(activity));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param activity ${table.comment}
   * @return XfR
   */
  @PutMapping("/activitys/{id}")
  public XfR putUpdate(@RequestBody Activity activity,@PathVariable Long id) {
      activity.setId(id);
      return XfR.ok(activityServiceImpl.updateById(activity));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param activity ${table.comment}
   * @return XfR
   */
  @PatchMapping("/activitys/{id}")
  public XfR patchUpdate(@RequestBody Activity activity,@PathVariable Long id) {
      Activity upactivity = activityServiceImpl.getById(id);
      if(upactivity != null){
        upactivity = ObjectCopyUtils.copyProperties(activity,upactivity,true);
      }
      return XfR.ok(activityServiceImpl.updateById(upactivity));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/activitys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(activityServiceImpl.removeById(id));
  }

  @PostMapping("/activitys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "activity");
     params.put("request", condition);

     return XfR.ok(activityServiceImpl.querys(params));
  }

}
