package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.VoucherGenerator;
import com.xforceplus.generalvoucher.service.IVoucherGeneratorService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-25
 */
@RestController
public class VoucherGeneratorController {

  @Autowired
  private IVoucherGeneratorService voucherGeneratorServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param voucherGenerator ${table.comment}
   * @return
   */
  @GetMapping("/vouchergenerators" )
  public XfR getVoucherGenerators(XfPage page, VoucherGenerator voucherGenerator) {
    return XfR.ok(voucherGeneratorServiceImpl.page(page, Wrappers.query(voucherGenerator)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/vouchergenerators/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(voucherGeneratorServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param voucherGenerator ${table.comment}
   * @return XfR
   */
  @PostMapping("/vouchergenerators")
  public XfR save(@RequestBody VoucherGenerator voucherGenerator) {
     return XfR.ok(voucherGeneratorServiceImpl.save(voucherGenerator));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param voucherGenerator ${table.comment}
   * @return XfR
   */
  @PutMapping("/vouchergenerators/{id}")
  public XfR putUpdate(@RequestBody VoucherGenerator voucherGenerator,@PathVariable Long id) {
      voucherGenerator.setId(id);
      return XfR.ok(voucherGeneratorServiceImpl.updateById(voucherGenerator));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param voucherGenerator ${table.comment}
   * @return XfR
   */
  @PatchMapping("/vouchergenerators/{id}")
  public XfR patchUpdate(@RequestBody VoucherGenerator voucherGenerator,@PathVariable Long id) {
      VoucherGenerator upvoucherGenerator = voucherGeneratorServiceImpl.getById(id);
      if(upvoucherGenerator != null){
        upvoucherGenerator = ObjectCopyUtils.copyProperties(voucherGenerator,upvoucherGenerator,true);
      }
      return XfR.ok(voucherGeneratorServiceImpl.updateById(upvoucherGenerator));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/vouchergenerators/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(voucherGeneratorServiceImpl.removeById(id));
  }

  @PostMapping("/vouchergenerators/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "voucher_generator");
     params.put("request", condition);

     return XfR.ok(voucherGeneratorServiceImpl.querys(params));
  }

}
