package com.xforceplus.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.generalvoucher.entity.AuditLog;
import com.xforceplus.generalvoucher.service.IAuditLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-26
 */
@RestController
public class AuditLogController {

  @Autowired
  private IAuditLogService auditLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param auditLog ${table.comment}
   * @return
   */
  @GetMapping("/auditlogs" )
  public XfR getAuditLogs(XfPage page, AuditLog auditLog) {
    return XfR.ok(auditLogServiceImpl.page(page, Wrappers.query(auditLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/auditlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(auditLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param auditLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/auditlogs")
  public XfR save(@RequestBody AuditLog auditLog) {
     return XfR.ok(auditLogServiceImpl.save(auditLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param auditLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/auditlogs/{id}")
  public XfR putUpdate(@RequestBody AuditLog auditLog,@PathVariable Long id) {
      auditLog.setId(id);
      return XfR.ok(auditLogServiceImpl.updateById(auditLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param auditLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/auditlogs/{id}")
  public XfR patchUpdate(@RequestBody AuditLog auditLog,@PathVariable Long id) {
      AuditLog upauditLog = auditLogServiceImpl.getById(id);
      if(upauditLog != null){
        upauditLog = ObjectCopyUtils.copyProperties(auditLog,upauditLog,true);
      }
      return XfR.ok(auditLogServiceImpl.updateById(upauditLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/auditlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(auditLogServiceImpl.removeById(id));
  }

  @PostMapping("/auditlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "audit_log");
     params.put("request", condition);

     return XfR.ok(auditLogServiceImpl.querys(params));
  }

}
