package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Dd;
import com.xforceplus.huigui150.service.IDdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * dd前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class DdController {

  @Autowired
  private IDdService ddServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dd dd
   * @return
   */
  @GetMapping("/dds" )
  public XfR getDds(XfPage page, Dd dd) {
    return XfR.ok(ddServiceImpl.page(page, Wrappers.query(dd)));
  }

  /**
   * 通过id查询dd
   * @param  id
   * @return XfR
   */
  @GetMapping("/dds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ddServiceImpl.getById(id));
  }

  /**
   * 新增dd
   * @param dd dd
   * @return XfR
   */
  @PostMapping("/dds")
  public XfR save(@RequestBody Dd dd) {
     return XfR.ok(ddServiceImpl.save(dd));
  }

  /**
   * 修改-传入修改后的全部数据dd
   * @param dd dd
   * @return XfR
   */
  @PutMapping("/dds/{id}")
  public XfR putUpdate(@RequestBody Dd dd,@PathVariable Long id) {
      dd.setId(id);
      return XfR.ok(ddServiceImpl.updateById(dd));
  }

  /**
   * 修改-传入修改的数据dd
   * @param dd dd
   * @return XfR
   */
  @PatchMapping("/dds/{id}")
  public XfR patchUpdate(@RequestBody Dd dd,@PathVariable Long id) {
      Dd updd = ddServiceImpl.getById(id);
      if(updd != null){
        updd = ObjectCopyUtils.copyProperties(dd,updd,true);
      }
      return XfR.ok(ddServiceImpl.updateById(updd));
  }

  /**
   * 通过id删除dd
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ddServiceImpl.removeById(id));
  }

  @PostMapping("/dds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dd");
     params.put("request", condition);

     return XfR.ok(ddServiceImpl.querys(params));
  }

}
