package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Dddd;
import com.xforceplus.huigui150.service.IDdddService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class DdddController {

  @Autowired
  private IDdddService ddddServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dddd ${table.comment}
   * @return
   */
  @GetMapping("/dddds" )
  public XfR getDddds(XfPage page, Dddd dddd) {
    return XfR.ok(ddddServiceImpl.page(page, Wrappers.query(dddd)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dddds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ddddServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dddd ${table.comment}
   * @return XfR
   */
  @PostMapping("/dddds")
  public XfR save(@RequestBody Dddd dddd) {
     return XfR.ok(ddddServiceImpl.save(dddd));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dddd ${table.comment}
   * @return XfR
   */
  @PutMapping("/dddds/{id}")
  public XfR putUpdate(@RequestBody Dddd dddd,@PathVariable Long id) {
      dddd.setId(id);
      return XfR.ok(ddddServiceImpl.updateById(dddd));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dddd ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dddds/{id}")
  public XfR patchUpdate(@RequestBody Dddd dddd,@PathVariable Long id) {
      Dddd updddd = ddddServiceImpl.getById(id);
      if(updddd != null){
        updddd = ObjectCopyUtils.copyProperties(dddd,updddd,true);
      }
      return XfR.ok(ddddServiceImpl.updateById(updddd));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dddds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ddddServiceImpl.removeById(id));
  }

  @PostMapping("/dddds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dddd");
     params.put("request", condition);

     return XfR.ok(ddddServiceImpl.querys(params));
  }

}
