package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Duo0831001;
import com.xforceplus.huigui150.service.IDuo0831001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * duo0831001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Duo0831001Controller {

  @Autowired
  private IDuo0831001Service duo0831001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param duo0831001 duo0831001
   * @return
   */
  @GetMapping("/duo0831001s" )
  public XfR getDuo0831001s(XfPage page, Duo0831001 duo0831001) {
    return XfR.ok(duo0831001ServiceImpl.page(page, Wrappers.query(duo0831001)));
  }

  /**
   * 通过id查询duo0831001
   * @param  id
   * @return XfR
   */
  @GetMapping("/duo0831001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(duo0831001ServiceImpl.getById(id));
  }

  /**
   * 新增duo0831001
   * @param duo0831001 duo0831001
   * @return XfR
   */
  @PostMapping("/duo0831001s")
  public XfR save(@RequestBody Duo0831001 duo0831001) {
     return XfR.ok(duo0831001ServiceImpl.save(duo0831001));
  }

  /**
   * 修改-传入修改后的全部数据duo0831001
   * @param duo0831001 duo0831001
   * @return XfR
   */
  @PutMapping("/duo0831001s/{id}")
  public XfR putUpdate(@RequestBody Duo0831001 duo0831001,@PathVariable Long id) {
      duo0831001.setId(id);
      return XfR.ok(duo0831001ServiceImpl.updateById(duo0831001));
  }

  /**
   * 修改-传入修改的数据duo0831001
   * @param duo0831001 duo0831001
   * @return XfR
   */
  @PatchMapping("/duo0831001s/{id}")
  public XfR patchUpdate(@RequestBody Duo0831001 duo0831001,@PathVariable Long id) {
      Duo0831001 upduo0831001 = duo0831001ServiceImpl.getById(id);
      if(upduo0831001 != null){
        upduo0831001 = ObjectCopyUtils.copyProperties(duo0831001,upduo0831001,true);
      }
      return XfR.ok(duo0831001ServiceImpl.updateById(upduo0831001));
  }

  /**
   * 通过id删除duo0831001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/duo0831001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(duo0831001ServiceImpl.removeById(id));
  }

  @PostMapping("/duo0831001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "duo0831001");
     params.put("request", condition);

     return XfR.ok(duo0831001ServiceImpl.querys(params));
  }

}
