package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Duo0923001;
import com.xforceplus.huigui150.service.IDuo0923001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * duo0923001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Duo0923001Controller {

  @Autowired
  private IDuo0923001Service duo0923001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param duo0923001 duo0923001
   * @return
   */
  @GetMapping("/duo0923001s" )
  public XfR getDuo0923001s(XfPage page, Duo0923001 duo0923001) {
    return XfR.ok(duo0923001ServiceImpl.page(page, Wrappers.query(duo0923001)));
  }

  /**
   * 通过id查询duo0923001
   * @param  id
   * @return XfR
   */
  @GetMapping("/duo0923001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(duo0923001ServiceImpl.getById(id));
  }

  /**
   * 新增duo0923001
   * @param duo0923001 duo0923001
   * @return XfR
   */
  @PostMapping("/duo0923001s")
  public XfR save(@RequestBody Duo0923001 duo0923001) {
     return XfR.ok(duo0923001ServiceImpl.save(duo0923001));
  }

  /**
   * 修改-传入修改后的全部数据duo0923001
   * @param duo0923001 duo0923001
   * @return XfR
   */
  @PutMapping("/duo0923001s/{id}")
  public XfR putUpdate(@RequestBody Duo0923001 duo0923001,@PathVariable Long id) {
      duo0923001.setId(id);
      return XfR.ok(duo0923001ServiceImpl.updateById(duo0923001));
  }

  /**
   * 修改-传入修改的数据duo0923001
   * @param duo0923001 duo0923001
   * @return XfR
   */
  @PatchMapping("/duo0923001s/{id}")
  public XfR patchUpdate(@RequestBody Duo0923001 duo0923001,@PathVariable Long id) {
      Duo0923001 upduo0923001 = duo0923001ServiceImpl.getById(id);
      if(upduo0923001 != null){
        upduo0923001 = ObjectCopyUtils.copyProperties(duo0923001,upduo0923001,true);
      }
      return XfR.ok(duo0923001ServiceImpl.updateById(upduo0923001));
  }

  /**
   * 通过id删除duo0923001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/duo0923001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(duo0923001ServiceImpl.removeById(id));
  }

  @PostMapping("/duo0923001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "duo0923001");
     params.put("request", condition);

     return XfR.ok(duo0923001ServiceImpl.querys(params));
  }

}
