package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Duoduiyi;
import com.xforceplus.huigui150.service.IDuoduiyiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * duoduiyi前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class DuoduiyiController {

  @Autowired
  private IDuoduiyiService duoduiyiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param duoduiyi duoduiyi
   * @return
   */
  @GetMapping("/duoduiyis" )
  public XfR getDuoduiyis(XfPage page, Duoduiyi duoduiyi) {
    return XfR.ok(duoduiyiServiceImpl.page(page, Wrappers.query(duoduiyi)));
  }

  /**
   * 通过id查询duoduiyi
   * @param  id
   * @return XfR
   */
  @GetMapping("/duoduiyis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(duoduiyiServiceImpl.getById(id));
  }

  /**
   * 新增duoduiyi
   * @param duoduiyi duoduiyi
   * @return XfR
   */
  @PostMapping("/duoduiyis")
  public XfR save(@RequestBody Duoduiyi duoduiyi) {
     return XfR.ok(duoduiyiServiceImpl.save(duoduiyi));
  }

  /**
   * 修改-传入修改后的全部数据duoduiyi
   * @param duoduiyi duoduiyi
   * @return XfR
   */
  @PutMapping("/duoduiyis/{id}")
  public XfR putUpdate(@RequestBody Duoduiyi duoduiyi,@PathVariable Long id) {
      duoduiyi.setId(id);
      return XfR.ok(duoduiyiServiceImpl.updateById(duoduiyi));
  }

  /**
   * 修改-传入修改的数据duoduiyi
   * @param duoduiyi duoduiyi
   * @return XfR
   */
  @PatchMapping("/duoduiyis/{id}")
  public XfR patchUpdate(@RequestBody Duoduiyi duoduiyi,@PathVariable Long id) {
      Duoduiyi upduoduiyi = duoduiyiServiceImpl.getById(id);
      if(upduoduiyi != null){
        upduoduiyi = ObjectCopyUtils.copyProperties(duoduiyi,upduoduiyi,true);
      }
      return XfR.ok(duoduiyiServiceImpl.updateById(upduoduiyi));
  }

  /**
   * 通过id删除duoduiyi
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/duoduiyis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(duoduiyiServiceImpl.removeById(id));
  }

  @PostMapping("/duoduiyis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "duoduiyi");
     params.put("request", condition);

     return XfR.ok(duoduiyiServiceImpl.querys(params));
  }

}
