package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Duozhileixing;
import com.xforceplus.huigui150.service.IDuozhileixingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * duozhileixing前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class DuozhileixingController {

  @Autowired
  private IDuozhileixingService duozhileixingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param duozhileixing duozhileixing
   * @return
   */
  @GetMapping("/duozhileixings" )
  public XfR getDuozhileixings(XfPage page, Duozhileixing duozhileixing) {
    return XfR.ok(duozhileixingServiceImpl.page(page, Wrappers.query(duozhileixing)));
  }

  /**
   * 通过id查询duozhileixing
   * @param  id
   * @return XfR
   */
  @GetMapping("/duozhileixings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(duozhileixingServiceImpl.getById(id));
  }

  /**
   * 新增duozhileixing
   * @param duozhileixing duozhileixing
   * @return XfR
   */
  @PostMapping("/duozhileixings")
  public XfR save(@RequestBody Duozhileixing duozhileixing) {
     return XfR.ok(duozhileixingServiceImpl.save(duozhileixing));
  }

  /**
   * 修改-传入修改后的全部数据duozhileixing
   * @param duozhileixing duozhileixing
   * @return XfR
   */
  @PutMapping("/duozhileixings/{id}")
  public XfR putUpdate(@RequestBody Duozhileixing duozhileixing,@PathVariable Long id) {
      duozhileixing.setId(id);
      return XfR.ok(duozhileixingServiceImpl.updateById(duozhileixing));
  }

  /**
   * 修改-传入修改的数据duozhileixing
   * @param duozhileixing duozhileixing
   * @return XfR
   */
  @PatchMapping("/duozhileixings/{id}")
  public XfR patchUpdate(@RequestBody Duozhileixing duozhileixing,@PathVariable Long id) {
      Duozhileixing upduozhileixing = duozhileixingServiceImpl.getById(id);
      if(upduozhileixing != null){
        upduozhileixing = ObjectCopyUtils.copyProperties(duozhileixing,upduozhileixing,true);
      }
      return XfR.ok(duozhileixingServiceImpl.updateById(upduozhileixing));
  }

  /**
   * 通过id删除duozhileixing
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/duozhileixings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(duozhileixingServiceImpl.removeById(id));
  }

  @PostMapping("/duozhileixings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "duozhileixing");
     params.put("request", condition);

     return XfR.ok(duozhileixingServiceImpl.querys(params));
  }

}
