package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Ee;
import com.xforceplus.huigui150.service.IEeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ee前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class EeController {

  @Autowired
  private IEeService eeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ee ee
   * @return
   */
  @GetMapping("/ees" )
  public XfR getEes(XfPage page, Ee ee) {
    return XfR.ok(eeServiceImpl.page(page, Wrappers.query(ee)));
  }

  /**
   * 通过id查询ee
   * @param  id
   * @return XfR
   */
  @GetMapping("/ees/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(eeServiceImpl.getById(id));
  }

  /**
   * 新增ee
   * @param ee ee
   * @return XfR
   */
  @PostMapping("/ees")
  public XfR save(@RequestBody Ee ee) {
     return XfR.ok(eeServiceImpl.save(ee));
  }

  /**
   * 修改-传入修改后的全部数据ee
   * @param ee ee
   * @return XfR
   */
  @PutMapping("/ees/{id}")
  public XfR putUpdate(@RequestBody Ee ee,@PathVariable Long id) {
      ee.setId(id);
      return XfR.ok(eeServiceImpl.updateById(ee));
  }

  /**
   * 修改-传入修改的数据ee
   * @param ee ee
   * @return XfR
   */
  @PatchMapping("/ees/{id}")
  public XfR patchUpdate(@RequestBody Ee ee,@PathVariable Long id) {
      Ee upee = eeServiceImpl.getById(id);
      if(upee != null){
        upee = ObjectCopyUtils.copyProperties(ee,upee,true);
      }
      return XfR.ok(eeServiceImpl.updateById(upee));
  }

  /**
   * 通过id删除ee
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ees/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(eeServiceImpl.removeById(id));
  }

  @PostMapping("/ees/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ee");
     params.put("request", condition);

     return XfR.ok(eeServiceImpl.querys(params));
  }

}
