package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Feature1;
import com.xforceplus.huigui150.service.IFeature1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * feature1前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Feature1Controller {

  @Autowired
  private IFeature1Service feature1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param feature1 feature1
   * @return
   */
  @GetMapping("/feature1s" )
  public XfR getFeature1s(XfPage page, Feature1 feature1) {
    return XfR.ok(feature1ServiceImpl.page(page, Wrappers.query(feature1)));
  }

  /**
   * 通过id查询feature1
   * @param  id
   * @return XfR
   */
  @GetMapping("/feature1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(feature1ServiceImpl.getById(id));
  }

  /**
   * 新增feature1
   * @param feature1 feature1
   * @return XfR
   */
  @PostMapping("/feature1s")
  public XfR save(@RequestBody Feature1 feature1) {
     return XfR.ok(feature1ServiceImpl.save(feature1));
  }

  /**
   * 修改-传入修改后的全部数据feature1
   * @param feature1 feature1
   * @return XfR
   */
  @PutMapping("/feature1s/{id}")
  public XfR putUpdate(@RequestBody Feature1 feature1,@PathVariable Long id) {
      feature1.setId(id);
      return XfR.ok(feature1ServiceImpl.updateById(feature1));
  }

  /**
   * 修改-传入修改的数据feature1
   * @param feature1 feature1
   * @return XfR
   */
  @PatchMapping("/feature1s/{id}")
  public XfR patchUpdate(@RequestBody Feature1 feature1,@PathVariable Long id) {
      Feature1 upfeature1 = feature1ServiceImpl.getById(id);
      if(upfeature1 != null){
        upfeature1 = ObjectCopyUtils.copyProperties(feature1,upfeature1,true);
      }
      return XfR.ok(feature1ServiceImpl.updateById(upfeature1));
  }

  /**
   * 通过id删除feature1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/feature1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(feature1ServiceImpl.removeById(id));
  }

  @PostMapping("/feature1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "feature1");
     params.put("request", condition);

     return XfR.ok(feature1ServiceImpl.querys(params));
  }

}
