package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Fenci;
import com.xforceplus.huigui150.service.IFenciService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * fenci前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class FenciController {

  @Autowired
  private IFenciService fenciServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fenci fenci
   * @return
   */
  @GetMapping("/fencis" )
  public XfR getFencis(XfPage page, Fenci fenci) {
    return XfR.ok(fenciServiceImpl.page(page, Wrappers.query(fenci)));
  }

  /**
   * 通过id查询fenci
   * @param  id
   * @return XfR
   */
  @GetMapping("/fencis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fenciServiceImpl.getById(id));
  }

  /**
   * 新增fenci
   * @param fenci fenci
   * @return XfR
   */
  @PostMapping("/fencis")
  public XfR save(@RequestBody Fenci fenci) {
     return XfR.ok(fenciServiceImpl.save(fenci));
  }

  /**
   * 修改-传入修改后的全部数据fenci
   * @param fenci fenci
   * @return XfR
   */
  @PutMapping("/fencis/{id}")
  public XfR putUpdate(@RequestBody Fenci fenci,@PathVariable Long id) {
      fenci.setId(id);
      return XfR.ok(fenciServiceImpl.updateById(fenci));
  }

  /**
   * 修改-传入修改的数据fenci
   * @param fenci fenci
   * @return XfR
   */
  @PatchMapping("/fencis/{id}")
  public XfR patchUpdate(@RequestBody Fenci fenci,@PathVariable Long id) {
      Fenci upfenci = fenciServiceImpl.getById(id);
      if(upfenci != null){
        upfenci = ObjectCopyUtils.copyProperties(fenci,upfenci,true);
      }
      return XfR.ok(fenciServiceImpl.updateById(upfenci));
  }

  /**
   * 通过id删除fenci
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fencis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fenciServiceImpl.removeById(id));
  }

  @PostMapping("/fencis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fenci");
     params.put("request", condition);

     return XfR.ok(fenciServiceImpl.querys(params));
  }

}
