package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Huigui0728001;
import com.xforceplus.huigui150.service.IHuigui0728001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * huigui0728001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Huigui0728001Controller {

  @Autowired
  private IHuigui0728001Service huigui0728001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huigui0728001 huigui0728001
   * @return
   */
  @GetMapping("/huigui0728001s" )
  public XfR getHuigui0728001s(XfPage page, Huigui0728001 huigui0728001) {
    return XfR.ok(huigui0728001ServiceImpl.page(page, Wrappers.query(huigui0728001)));
  }

  /**
   * 通过id查询huigui0728001
   * @param  id
   * @return XfR
   */
  @GetMapping("/huigui0728001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huigui0728001ServiceImpl.getById(id));
  }

  /**
   * 新增huigui0728001
   * @param huigui0728001 huigui0728001
   * @return XfR
   */
  @PostMapping("/huigui0728001s")
  public XfR save(@RequestBody Huigui0728001 huigui0728001) {
     return XfR.ok(huigui0728001ServiceImpl.save(huigui0728001));
  }

  /**
   * 修改-传入修改后的全部数据huigui0728001
   * @param huigui0728001 huigui0728001
   * @return XfR
   */
  @PutMapping("/huigui0728001s/{id}")
  public XfR putUpdate(@RequestBody Huigui0728001 huigui0728001,@PathVariable Long id) {
      huigui0728001.setId(id);
      return XfR.ok(huigui0728001ServiceImpl.updateById(huigui0728001));
  }

  /**
   * 修改-传入修改的数据huigui0728001
   * @param huigui0728001 huigui0728001
   * @return XfR
   */
  @PatchMapping("/huigui0728001s/{id}")
  public XfR patchUpdate(@RequestBody Huigui0728001 huigui0728001,@PathVariable Long id) {
      Huigui0728001 uphuigui0728001 = huigui0728001ServiceImpl.getById(id);
      if(uphuigui0728001 != null){
        uphuigui0728001 = ObjectCopyUtils.copyProperties(huigui0728001,uphuigui0728001,true);
      }
      return XfR.ok(huigui0728001ServiceImpl.updateById(uphuigui0728001));
  }

  /**
   * 通过id删除huigui0728001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huigui0728001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huigui0728001ServiceImpl.removeById(id));
  }

  @PostMapping("/huigui0728001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huigui0728001");
     params.put("request", condition);

     return XfR.ok(huigui0728001ServiceImpl.querys(params));
  }

}
