package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Huigui0728004;
import com.xforceplus.huigui150.service.IHuigui0728004Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * huigui0728004前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Huigui0728004Controller {

  @Autowired
  private IHuigui0728004Service huigui0728004ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huigui0728004 huigui0728004
   * @return
   */
  @GetMapping("/huigui0728004s" )
  public XfR getHuigui0728004s(XfPage page, Huigui0728004 huigui0728004) {
    return XfR.ok(huigui0728004ServiceImpl.page(page, Wrappers.query(huigui0728004)));
  }

  /**
   * 通过id查询huigui0728004
   * @param  id
   * @return XfR
   */
  @GetMapping("/huigui0728004s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huigui0728004ServiceImpl.getById(id));
  }

  /**
   * 新增huigui0728004
   * @param huigui0728004 huigui0728004
   * @return XfR
   */
  @PostMapping("/huigui0728004s")
  public XfR save(@RequestBody Huigui0728004 huigui0728004) {
     return XfR.ok(huigui0728004ServiceImpl.save(huigui0728004));
  }

  /**
   * 修改-传入修改后的全部数据huigui0728004
   * @param huigui0728004 huigui0728004
   * @return XfR
   */
  @PutMapping("/huigui0728004s/{id}")
  public XfR putUpdate(@RequestBody Huigui0728004 huigui0728004,@PathVariable Long id) {
      huigui0728004.setId(id);
      return XfR.ok(huigui0728004ServiceImpl.updateById(huigui0728004));
  }

  /**
   * 修改-传入修改的数据huigui0728004
   * @param huigui0728004 huigui0728004
   * @return XfR
   */
  @PatchMapping("/huigui0728004s/{id}")
  public XfR patchUpdate(@RequestBody Huigui0728004 huigui0728004,@PathVariable Long id) {
      Huigui0728004 uphuigui0728004 = huigui0728004ServiceImpl.getById(id);
      if(uphuigui0728004 != null){
        uphuigui0728004 = ObjectCopyUtils.copyProperties(huigui0728004,uphuigui0728004,true);
      }
      return XfR.ok(huigui0728004ServiceImpl.updateById(uphuigui0728004));
  }

  /**
   * 通过id删除huigui0728004
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huigui0728004s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huigui0728004ServiceImpl.removeById(id));
  }

  @PostMapping("/huigui0728004s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huigui0728004");
     params.put("request", condition);

     return XfR.ok(huigui0728004ServiceImpl.querys(params));
  }

}
