package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Huigui0728005;
import com.xforceplus.huigui150.service.IHuigui0728005Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * huigui0728005前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Huigui0728005Controller {

  @Autowired
  private IHuigui0728005Service huigui0728005ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huigui0728005 huigui0728005
   * @return
   */
  @GetMapping("/huigui0728005s" )
  public XfR getHuigui0728005s(XfPage page, Huigui0728005 huigui0728005) {
    return XfR.ok(huigui0728005ServiceImpl.page(page, Wrappers.query(huigui0728005)));
  }

  /**
   * 通过id查询huigui0728005
   * @param  id
   * @return XfR
   */
  @GetMapping("/huigui0728005s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huigui0728005ServiceImpl.getById(id));
  }

  /**
   * 新增huigui0728005
   * @param huigui0728005 huigui0728005
   * @return XfR
   */
  @PostMapping("/huigui0728005s")
  public XfR save(@RequestBody Huigui0728005 huigui0728005) {
     return XfR.ok(huigui0728005ServiceImpl.save(huigui0728005));
  }

  /**
   * 修改-传入修改后的全部数据huigui0728005
   * @param huigui0728005 huigui0728005
   * @return XfR
   */
  @PutMapping("/huigui0728005s/{id}")
  public XfR putUpdate(@RequestBody Huigui0728005 huigui0728005,@PathVariable Long id) {
      huigui0728005.setId(id);
      return XfR.ok(huigui0728005ServiceImpl.updateById(huigui0728005));
  }

  /**
   * 修改-传入修改的数据huigui0728005
   * @param huigui0728005 huigui0728005
   * @return XfR
   */
  @PatchMapping("/huigui0728005s/{id}")
  public XfR patchUpdate(@RequestBody Huigui0728005 huigui0728005,@PathVariable Long id) {
      Huigui0728005 uphuigui0728005 = huigui0728005ServiceImpl.getById(id);
      if(uphuigui0728005 != null){
        uphuigui0728005 = ObjectCopyUtils.copyProperties(huigui0728005,uphuigui0728005,true);
      }
      return XfR.ok(huigui0728005ServiceImpl.updateById(uphuigui0728005));
  }

  /**
   * 通过id删除huigui0728005
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huigui0728005s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huigui0728005ServiceImpl.removeById(id));
  }

  @PostMapping("/huigui0728005s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huigui0728005");
     params.put("request", condition);

     return XfR.ok(huigui0728005ServiceImpl.querys(params));
  }

}
