package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Huigui0730001;
import com.xforceplus.huigui150.service.IHuigui0730001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * huigui0730001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Huigui0730001Controller {

  @Autowired
  private IHuigui0730001Service huigui0730001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huigui0730001 huigui0730001
   * @return
   */
  @GetMapping("/huigui0730001s" )
  public XfR getHuigui0730001s(XfPage page, Huigui0730001 huigui0730001) {
    return XfR.ok(huigui0730001ServiceImpl.page(page, Wrappers.query(huigui0730001)));
  }

  /**
   * 通过id查询huigui0730001
   * @param  id
   * @return XfR
   */
  @GetMapping("/huigui0730001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huigui0730001ServiceImpl.getById(id));
  }

  /**
   * 新增huigui0730001
   * @param huigui0730001 huigui0730001
   * @return XfR
   */
  @PostMapping("/huigui0730001s")
  public XfR save(@RequestBody Huigui0730001 huigui0730001) {
     return XfR.ok(huigui0730001ServiceImpl.save(huigui0730001));
  }

  /**
   * 修改-传入修改后的全部数据huigui0730001
   * @param huigui0730001 huigui0730001
   * @return XfR
   */
  @PutMapping("/huigui0730001s/{id}")
  public XfR putUpdate(@RequestBody Huigui0730001 huigui0730001,@PathVariable Long id) {
      huigui0730001.setId(id);
      return XfR.ok(huigui0730001ServiceImpl.updateById(huigui0730001));
  }

  /**
   * 修改-传入修改的数据huigui0730001
   * @param huigui0730001 huigui0730001
   * @return XfR
   */
  @PatchMapping("/huigui0730001s/{id}")
  public XfR patchUpdate(@RequestBody Huigui0730001 huigui0730001,@PathVariable Long id) {
      Huigui0730001 uphuigui0730001 = huigui0730001ServiceImpl.getById(id);
      if(uphuigui0730001 != null){
        uphuigui0730001 = ObjectCopyUtils.copyProperties(huigui0730001,uphuigui0730001,true);
      }
      return XfR.ok(huigui0730001ServiceImpl.updateById(uphuigui0730001));
  }

  /**
   * 通过id删除huigui0730001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huigui0730001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huigui0730001ServiceImpl.removeById(id));
  }

  @PostMapping("/huigui0730001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huigui0730001");
     params.put("request", condition);

     return XfR.ok(huigui0730001ServiceImpl.querys(params));
  }

}
