package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Huigui0730002;
import com.xforceplus.huigui150.service.IHuigui0730002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * huigui0730002前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Huigui0730002Controller {

  @Autowired
  private IHuigui0730002Service huigui0730002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huigui0730002 huigui0730002
   * @return
   */
  @GetMapping("/huigui0730002s" )
  public XfR getHuigui0730002s(XfPage page, Huigui0730002 huigui0730002) {
    return XfR.ok(huigui0730002ServiceImpl.page(page, Wrappers.query(huigui0730002)));
  }

  /**
   * 通过id查询huigui0730002
   * @param  id
   * @return XfR
   */
  @GetMapping("/huigui0730002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huigui0730002ServiceImpl.getById(id));
  }

  /**
   * 新增huigui0730002
   * @param huigui0730002 huigui0730002
   * @return XfR
   */
  @PostMapping("/huigui0730002s")
  public XfR save(@RequestBody Huigui0730002 huigui0730002) {
     return XfR.ok(huigui0730002ServiceImpl.save(huigui0730002));
  }

  /**
   * 修改-传入修改后的全部数据huigui0730002
   * @param huigui0730002 huigui0730002
   * @return XfR
   */
  @PutMapping("/huigui0730002s/{id}")
  public XfR putUpdate(@RequestBody Huigui0730002 huigui0730002,@PathVariable Long id) {
      huigui0730002.setId(id);
      return XfR.ok(huigui0730002ServiceImpl.updateById(huigui0730002));
  }

  /**
   * 修改-传入修改的数据huigui0730002
   * @param huigui0730002 huigui0730002
   * @return XfR
   */
  @PatchMapping("/huigui0730002s/{id}")
  public XfR patchUpdate(@RequestBody Huigui0730002 huigui0730002,@PathVariable Long id) {
      Huigui0730002 uphuigui0730002 = huigui0730002ServiceImpl.getById(id);
      if(uphuigui0730002 != null){
        uphuigui0730002 = ObjectCopyUtils.copyProperties(huigui0730002,uphuigui0730002,true);
      }
      return XfR.ok(huigui0730002ServiceImpl.updateById(uphuigui0730002));
  }

  /**
   * 通过id删除huigui0730002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huigui0730002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huigui0730002ServiceImpl.removeById(id));
  }

  @PostMapping("/huigui0730002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huigui0730002");
     params.put("request", condition);

     return XfR.ok(huigui0730002ServiceImpl.querys(params));
  }

}
