package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Huigui0730003;
import com.xforceplus.huigui150.service.IHuigui0730003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * huigui0730003前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Huigui0730003Controller {

  @Autowired
  private IHuigui0730003Service huigui0730003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huigui0730003 huigui0730003
   * @return
   */
  @GetMapping("/huigui0730003s" )
  public XfR getHuigui0730003s(XfPage page, Huigui0730003 huigui0730003) {
    return XfR.ok(huigui0730003ServiceImpl.page(page, Wrappers.query(huigui0730003)));
  }

  /**
   * 通过id查询huigui0730003
   * @param  id
   * @return XfR
   */
  @GetMapping("/huigui0730003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huigui0730003ServiceImpl.getById(id));
  }

  /**
   * 新增huigui0730003
   * @param huigui0730003 huigui0730003
   * @return XfR
   */
  @PostMapping("/huigui0730003s")
  public XfR save(@RequestBody Huigui0730003 huigui0730003) {
     return XfR.ok(huigui0730003ServiceImpl.save(huigui0730003));
  }

  /**
   * 修改-传入修改后的全部数据huigui0730003
   * @param huigui0730003 huigui0730003
   * @return XfR
   */
  @PutMapping("/huigui0730003s/{id}")
  public XfR putUpdate(@RequestBody Huigui0730003 huigui0730003,@PathVariable Long id) {
      huigui0730003.setId(id);
      return XfR.ok(huigui0730003ServiceImpl.updateById(huigui0730003));
  }

  /**
   * 修改-传入修改的数据huigui0730003
   * @param huigui0730003 huigui0730003
   * @return XfR
   */
  @PatchMapping("/huigui0730003s/{id}")
  public XfR patchUpdate(@RequestBody Huigui0730003 huigui0730003,@PathVariable Long id) {
      Huigui0730003 uphuigui0730003 = huigui0730003ServiceImpl.getById(id);
      if(uphuigui0730003 != null){
        uphuigui0730003 = ObjectCopyUtils.copyProperties(huigui0730003,uphuigui0730003,true);
      }
      return XfR.ok(huigui0730003ServiceImpl.updateById(uphuigui0730003));
  }

  /**
   * 通过id删除huigui0730003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huigui0730003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huigui0730003ServiceImpl.removeById(id));
  }

  @PostMapping("/huigui0730003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huigui0730003");
     params.put("request", condition);

     return XfR.ok(huigui0730003ServiceImpl.querys(params));
  }

}
