package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Inchaxun;
import com.xforceplus.huigui150.service.IInchaxunService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * inchaxun前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class InchaxunController {

  @Autowired
  private IInchaxunService inchaxunServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inchaxun inchaxun
   * @return
   */
  @GetMapping("/inchaxuns" )
  public XfR getInchaxuns(XfPage page, Inchaxun inchaxun) {
    return XfR.ok(inchaxunServiceImpl.page(page, Wrappers.query(inchaxun)));
  }

  /**
   * 通过id查询inchaxun
   * @param  id
   * @return XfR
   */
  @GetMapping("/inchaxuns/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inchaxunServiceImpl.getById(id));
  }

  /**
   * 新增inchaxun
   * @param inchaxun inchaxun
   * @return XfR
   */
  @PostMapping("/inchaxuns")
  public XfR save(@RequestBody Inchaxun inchaxun) {
     return XfR.ok(inchaxunServiceImpl.save(inchaxun));
  }

  /**
   * 修改-传入修改后的全部数据inchaxun
   * @param inchaxun inchaxun
   * @return XfR
   */
  @PutMapping("/inchaxuns/{id}")
  public XfR putUpdate(@RequestBody Inchaxun inchaxun,@PathVariable Long id) {
      inchaxun.setId(id);
      return XfR.ok(inchaxunServiceImpl.updateById(inchaxun));
  }

  /**
   * 修改-传入修改的数据inchaxun
   * @param inchaxun inchaxun
   * @return XfR
   */
  @PatchMapping("/inchaxuns/{id}")
  public XfR patchUpdate(@RequestBody Inchaxun inchaxun,@PathVariable Long id) {
      Inchaxun upinchaxun = inchaxunServiceImpl.getById(id);
      if(upinchaxun != null){
        upinchaxun = ObjectCopyUtils.copyProperties(inchaxun,upinchaxun,true);
      }
      return XfR.ok(inchaxunServiceImpl.updateById(upinchaxun));
  }

  /**
   * 通过id删除inchaxun
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inchaxuns/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inchaxunServiceImpl.removeById(id));
  }

  @PostMapping("/inchaxuns/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inchaxun");
     params.put("request", condition);

     return XfR.ok(inchaxunServiceImpl.querys(params));
  }

}
