package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Invocie;
import com.xforceplus.huigui150.service.IInvocieService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class InvocieController {

  @Autowired
  private IInvocieService invocieServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invocie ${table.comment}
   * @return
   */
  @GetMapping("/invocies" )
  public XfR getInvocies(XfPage page, Invocie invocie) {
    return XfR.ok(invocieServiceImpl.page(page, Wrappers.query(invocie)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invocies/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invocieServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invocie ${table.comment}
   * @return XfR
   */
  @PostMapping("/invocies")
  public XfR save(@RequestBody Invocie invocie) {
     return XfR.ok(invocieServiceImpl.save(invocie));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invocie ${table.comment}
   * @return XfR
   */
  @PutMapping("/invocies/{id}")
  public XfR putUpdate(@RequestBody Invocie invocie,@PathVariable Long id) {
      invocie.setId(id);
      return XfR.ok(invocieServiceImpl.updateById(invocie));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invocie ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invocies/{id}")
  public XfR patchUpdate(@RequestBody Invocie invocie,@PathVariable Long id) {
      Invocie upinvocie = invocieServiceImpl.getById(id);
      if(upinvocie != null){
        upinvocie = ObjectCopyUtils.copyProperties(invocie,upinvocie,true);
      }
      return XfR.ok(invocieServiceImpl.updateById(upinvocie));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invocies/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invocieServiceImpl.removeById(id));
  }

  @PostMapping("/invocies/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invocie");
     params.put("request", condition);

     return XfR.ok(invocieServiceImpl.querys(params));
  }

}
