package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Juhe0730001;
import com.xforceplus.huigui150.service.IJuhe0730001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * juhe0730001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Juhe0730001Controller {

  @Autowired
  private IJuhe0730001Service juhe0730001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param juhe0730001 juhe0730001
   * @return
   */
  @GetMapping("/juhe0730001s" )
  public XfR getJuhe0730001s(XfPage page, Juhe0730001 juhe0730001) {
    return XfR.ok(juhe0730001ServiceImpl.page(page, Wrappers.query(juhe0730001)));
  }

  /**
   * 通过id查询juhe0730001
   * @param  id
   * @return XfR
   */
  @GetMapping("/juhe0730001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(juhe0730001ServiceImpl.getById(id));
  }

  /**
   * 新增juhe0730001
   * @param juhe0730001 juhe0730001
   * @return XfR
   */
  @PostMapping("/juhe0730001s")
  public XfR save(@RequestBody Juhe0730001 juhe0730001) {
     return XfR.ok(juhe0730001ServiceImpl.save(juhe0730001));
  }

  /**
   * 修改-传入修改后的全部数据juhe0730001
   * @param juhe0730001 juhe0730001
   * @return XfR
   */
  @PutMapping("/juhe0730001s/{id}")
  public XfR putUpdate(@RequestBody Juhe0730001 juhe0730001,@PathVariable Long id) {
      juhe0730001.setId(id);
      return XfR.ok(juhe0730001ServiceImpl.updateById(juhe0730001));
  }

  /**
   * 修改-传入修改的数据juhe0730001
   * @param juhe0730001 juhe0730001
   * @return XfR
   */
  @PatchMapping("/juhe0730001s/{id}")
  public XfR patchUpdate(@RequestBody Juhe0730001 juhe0730001,@PathVariable Long id) {
      Juhe0730001 upjuhe0730001 = juhe0730001ServiceImpl.getById(id);
      if(upjuhe0730001 != null){
        upjuhe0730001 = ObjectCopyUtils.copyProperties(juhe0730001,upjuhe0730001,true);
      }
      return XfR.ok(juhe0730001ServiceImpl.updateById(upjuhe0730001));
  }

  /**
   * 通过id删除juhe0730001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/juhe0730001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(juhe0730001ServiceImpl.removeById(id));
  }

  @PostMapping("/juhe0730001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "juhe0730001");
     params.put("request", condition);

     return XfR.ok(juhe0730001ServiceImpl.querys(params));
  }

}
