package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Juhe0903001;
import com.xforceplus.huigui150.service.IJuhe0903001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * juhe0903001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Juhe0903001Controller {

  @Autowired
  private IJuhe0903001Service juhe0903001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param juhe0903001 juhe0903001
   * @return
   */
  @GetMapping("/juhe0903001s" )
  public XfR getJuhe0903001s(XfPage page, Juhe0903001 juhe0903001) {
    return XfR.ok(juhe0903001ServiceImpl.page(page, Wrappers.query(juhe0903001)));
  }

  /**
   * 通过id查询juhe0903001
   * @param  id
   * @return XfR
   */
  @GetMapping("/juhe0903001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(juhe0903001ServiceImpl.getById(id));
  }

  /**
   * 新增juhe0903001
   * @param juhe0903001 juhe0903001
   * @return XfR
   */
  @PostMapping("/juhe0903001s")
  public XfR save(@RequestBody Juhe0903001 juhe0903001) {
     return XfR.ok(juhe0903001ServiceImpl.save(juhe0903001));
  }

  /**
   * 修改-传入修改后的全部数据juhe0903001
   * @param juhe0903001 juhe0903001
   * @return XfR
   */
  @PutMapping("/juhe0903001s/{id}")
  public XfR putUpdate(@RequestBody Juhe0903001 juhe0903001,@PathVariable Long id) {
      juhe0903001.setId(id);
      return XfR.ok(juhe0903001ServiceImpl.updateById(juhe0903001));
  }

  /**
   * 修改-传入修改的数据juhe0903001
   * @param juhe0903001 juhe0903001
   * @return XfR
   */
  @PatchMapping("/juhe0903001s/{id}")
  public XfR patchUpdate(@RequestBody Juhe0903001 juhe0903001,@PathVariable Long id) {
      Juhe0903001 upjuhe0903001 = juhe0903001ServiceImpl.getById(id);
      if(upjuhe0903001 != null){
        upjuhe0903001 = ObjectCopyUtils.copyProperties(juhe0903001,upjuhe0903001,true);
      }
      return XfR.ok(juhe0903001ServiceImpl.updateById(upjuhe0903001));
  }

  /**
   * 通过id删除juhe0903001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/juhe0903001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(juhe0903001ServiceImpl.removeById(id));
  }

  @PostMapping("/juhe0903001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "juhe0903001");
     params.put("request", condition);

     return XfR.ok(juhe0903001ServiceImpl.querys(params));
  }

}
