package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Lookup0729001;
import com.xforceplus.huigui150.service.ILookup0729001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * lookup0729001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Lookup0729001Controller {

  @Autowired
  private ILookup0729001Service lookup0729001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup0729001 lookup0729001
   * @return
   */
  @GetMapping("/lookup0729001s" )
  public XfR getLookup0729001s(XfPage page, Lookup0729001 lookup0729001) {
    return XfR.ok(lookup0729001ServiceImpl.page(page, Wrappers.query(lookup0729001)));
  }

  /**
   * 通过id查询lookup0729001
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup0729001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup0729001ServiceImpl.getById(id));
  }

  /**
   * 新增lookup0729001
   * @param lookup0729001 lookup0729001
   * @return XfR
   */
  @PostMapping("/lookup0729001s")
  public XfR save(@RequestBody Lookup0729001 lookup0729001) {
     return XfR.ok(lookup0729001ServiceImpl.save(lookup0729001));
  }

  /**
   * 修改-传入修改后的全部数据lookup0729001
   * @param lookup0729001 lookup0729001
   * @return XfR
   */
  @PutMapping("/lookup0729001s/{id}")
  public XfR putUpdate(@RequestBody Lookup0729001 lookup0729001,@PathVariable Long id) {
      lookup0729001.setId(id);
      return XfR.ok(lookup0729001ServiceImpl.updateById(lookup0729001));
  }

  /**
   * 修改-传入修改的数据lookup0729001
   * @param lookup0729001 lookup0729001
   * @return XfR
   */
  @PatchMapping("/lookup0729001s/{id}")
  public XfR patchUpdate(@RequestBody Lookup0729001 lookup0729001,@PathVariable Long id) {
      Lookup0729001 uplookup0729001 = lookup0729001ServiceImpl.getById(id);
      if(uplookup0729001 != null){
        uplookup0729001 = ObjectCopyUtils.copyProperties(lookup0729001,uplookup0729001,true);
      }
      return XfR.ok(lookup0729001ServiceImpl.updateById(uplookup0729001));
  }

  /**
   * 通过id删除lookup0729001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup0729001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup0729001ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup0729001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup0729001");
     params.put("request", condition);

     return XfR.ok(lookup0729001ServiceImpl.querys(params));
  }

}
