package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Lookup0730001;
import com.xforceplus.huigui150.service.ILookup0730001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * lookup0730001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Lookup0730001Controller {

  @Autowired
  private ILookup0730001Service lookup0730001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup0730001 lookup0730001
   * @return
   */
  @GetMapping("/lookup0730001s" )
  public XfR getLookup0730001s(XfPage page, Lookup0730001 lookup0730001) {
    return XfR.ok(lookup0730001ServiceImpl.page(page, Wrappers.query(lookup0730001)));
  }

  /**
   * 通过id查询lookup0730001
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup0730001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup0730001ServiceImpl.getById(id));
  }

  /**
   * 新增lookup0730001
   * @param lookup0730001 lookup0730001
   * @return XfR
   */
  @PostMapping("/lookup0730001s")
  public XfR save(@RequestBody Lookup0730001 lookup0730001) {
     return XfR.ok(lookup0730001ServiceImpl.save(lookup0730001));
  }

  /**
   * 修改-传入修改后的全部数据lookup0730001
   * @param lookup0730001 lookup0730001
   * @return XfR
   */
  @PutMapping("/lookup0730001s/{id}")
  public XfR putUpdate(@RequestBody Lookup0730001 lookup0730001,@PathVariable Long id) {
      lookup0730001.setId(id);
      return XfR.ok(lookup0730001ServiceImpl.updateById(lookup0730001));
  }

  /**
   * 修改-传入修改的数据lookup0730001
   * @param lookup0730001 lookup0730001
   * @return XfR
   */
  @PatchMapping("/lookup0730001s/{id}")
  public XfR patchUpdate(@RequestBody Lookup0730001 lookup0730001,@PathVariable Long id) {
      Lookup0730001 uplookup0730001 = lookup0730001ServiceImpl.getById(id);
      if(uplookup0730001 != null){
        uplookup0730001 = ObjectCopyUtils.copyProperties(lookup0730001,uplookup0730001,true);
      }
      return XfR.ok(lookup0730001ServiceImpl.updateById(uplookup0730001));
  }

  /**
   * 通过id删除lookup0730001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup0730001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup0730001ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup0730001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup0730001");
     params.put("request", condition);

     return XfR.ok(lookup0730001ServiceImpl.querys(params));
  }

}
