package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Lookup0730003;
import com.xforceplus.huigui150.service.ILookup0730003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * lookup0730003前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Lookup0730003Controller {

  @Autowired
  private ILookup0730003Service lookup0730003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup0730003 lookup0730003
   * @return
   */
  @GetMapping("/lookup0730003s" )
  public XfR getLookup0730003s(XfPage page, Lookup0730003 lookup0730003) {
    return XfR.ok(lookup0730003ServiceImpl.page(page, Wrappers.query(lookup0730003)));
  }

  /**
   * 通过id查询lookup0730003
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup0730003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup0730003ServiceImpl.getById(id));
  }

  /**
   * 新增lookup0730003
   * @param lookup0730003 lookup0730003
   * @return XfR
   */
  @PostMapping("/lookup0730003s")
  public XfR save(@RequestBody Lookup0730003 lookup0730003) {
     return XfR.ok(lookup0730003ServiceImpl.save(lookup0730003));
  }

  /**
   * 修改-传入修改后的全部数据lookup0730003
   * @param lookup0730003 lookup0730003
   * @return XfR
   */
  @PutMapping("/lookup0730003s/{id}")
  public XfR putUpdate(@RequestBody Lookup0730003 lookup0730003,@PathVariable Long id) {
      lookup0730003.setId(id);
      return XfR.ok(lookup0730003ServiceImpl.updateById(lookup0730003));
  }

  /**
   * 修改-传入修改的数据lookup0730003
   * @param lookup0730003 lookup0730003
   * @return XfR
   */
  @PatchMapping("/lookup0730003s/{id}")
  public XfR patchUpdate(@RequestBody Lookup0730003 lookup0730003,@PathVariable Long id) {
      Lookup0730003 uplookup0730003 = lookup0730003ServiceImpl.getById(id);
      if(uplookup0730003 != null){
        uplookup0730003 = ObjectCopyUtils.copyProperties(lookup0730003,uplookup0730003,true);
      }
      return XfR.ok(lookup0730003ServiceImpl.updateById(uplookup0730003));
  }

  /**
   * 通过id删除lookup0730003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup0730003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup0730003ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup0730003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup0730003");
     params.put("request", condition);

     return XfR.ok(lookup0730003ServiceImpl.querys(params));
  }

}
